#Include <Misc.au3>

$dll = DllOpen("user32.dll")

Global $MouseX = 0 
Global $MouseY = 0
Global $FocusPower = 0
Global $CurrentAppFocus = ""
Global $mousezone = 0

Global $square_left = 0
Global $square_right = 0
Global $square_top = 0
Global $square_bottom = 0

Global $zone2enable = Int(RegRead("HKEY_CURRENT_USER\SOFTWARE\IGOCFMONITOR", "zone2enable"))

Global $square_left2 = ""
Global $square_right2 = ""
Global $square_top2 = ""
Global $square_bottom2 = ""

Global $Appname = ""
Global $AppPath = ""
	
Global $debug = 0
Global $tooltips = 0
Initialise()

Splash_On("Initialise Application")
sleep(1000)


;Program Starts Here

;Start Main Control Loop
While 1
	
	Splash_On("Waiting for APP to Launch")
	;Wait for Application to Launch, If Application is already launched this function will exit immediatly
	WinExistsWait()
	Splash_Off()
	
	;If the Application already has focus then just wait for it to be lost
	If WinActive ( $Appname ) Then
		Display_Refocus_Enabled()
		WinWaitNotActive ( $Appname )
		$mousezone = 0
		$FocusPower = 1
	EndIf

	;Get Mouse Coords
	GetMouse()
	
	;Mouse Position
	SetMouseZone()

	Splash_On($MouseX &","&$MouseY&" MZ:"&$mousezone)

	;Allow Defocusing here
	If $mousezone = 1 Then 
		
		WinSetOnTop($Appname,"",0)
		WinSetState($Appname,"",@SW_MINIMIZE)
	
	EndIf
	
	;Slight Pause
	Sleep(100)

	If ProcessExists("centrafuse.exe") = 0 then Exit(1)

Wend

Exit(1)


Func Splash_On($splashtext)
	If $debug = 1 Then SplashTextOn( " " & $splashtext, " " & $splashtext, 400,23,50,50,5)
EndFunc

Func Splash_Off()
	SplashOff()
EndFunc

Func Display_Refocus_Disabled()
	If $tooltips = 1 Then SplashTextOn( " Mouse Monitoring Disabled.", " Mouse Monitoring Disabled.", 300,23,3,3,5)
	Sleep(750)
	Splash_Off()
EndFunc

Func Display_Refocus_Enabled()
	If $tooltips = 1 Then SplashTextOn( " Mouse Monitoring Enabled.", " Mouse Monitoring Enabled.", 300,23,3,3,5)
	Sleep(750)
	Splash_Off()
EndFunc

Func GetMouse()
	$pos = MouseGetPos()
	$MouseX = $pos[0]
	$MouseY = $pos[1]
EndFunc

Func SetMouseZone()
	
	$mousezone = 0
	
	If $MouseX > $square_left and $MouseX < $square_right Then
		
		If $MouseY > $square_top and $MouseY < $square_bottom Then
		
			$mousezone = 1
		
		EndIf
		
	EndIf
	
	If $zone2enable = 1 Then
		
		If $MouseX > $square_left2 and $MouseX < $square_right2 Then
		
			If $MouseY > $square_top2 and $MouseY < $square_bottom2 Then
		
				$mousezone = 1
		
			EndIf
		
		EndIf
		
	EndIf
	
	
EndFunc

Func WinExistsWait()
	
	While 1
			
		If WinExists ( $Appname ) Then ExitLoop
		sleep(1000)
		
	WEnd

EndFunc

Func ActivateApp()
	;Give our application Focus 
	WinActivate ( $Appname )
EndFunc

Func WaitMouseUp()

	Splash_On("Wait Mouse Up")
	While 1
			If ((_IsPressed("01", $dll)) = 0) Then ExitLoop
	WEnd
	Splash_Off()	

EndFunc

Func Initialise()
	$square_left = Int(RegRead("HKEY_CURRENT_USER\Software\IGOCFMONITOR", "left"))
	$square_right = Int(RegRead("HKEY_CURRENT_USER\SOFTWARE\IGOCFMONITOR", "right"))
	$square_top = Int(RegRead("HKEY_CURRENT_USER\SOFTWARE\IGOCFMONITOR", "top"))
	$square_bottom = Int(RegRead("HKEY_CURRENT_USER\SOFTWARE\IGOCFMONITOR", "bottom"))

	$zone2enable = Int(RegRead("HKEY_CURRENT_USER\SOFTWARE\IGOCFMONITOR", "zone2enable"))

	$square_left2 = Int(RegRead("HKEY_CURRENT_USER\Software\IGOCFMONITOR", "left2"))
	$square_right2 = Int(RegRead("HKEY_CURRENT_USER\SOFTWARE\IGOCFMONITOR", "right2"))
	$square_top2 = Int(RegRead("HKEY_CURRENT_USER\SOFTWARE\IGOCFMONITOR", "top2"))
	$square_bottom2 = Int(RegRead("HKEY_CURRENT_USER\SOFTWARE\IGOCFMONITOR", "bottom2"))

	$Appname = RegRead("HKEY_CURRENT_USER\SOFTWARE\IGOCFMONITOR", "APPNAME")
	$AppPath = RegRead("HKEY_CURRENT_USER\SOFTWARE\IGOCFMONITOR", "APPPATH")
	$AppWorkingDir = RegRead("HKEY_CURRENT_USER\SOFTWARE\IGOCFMONITOR", "APPWORKINGDIR")
	
	$debug = RegRead("HKEY_CURRENT_USER\SOFTWARE\IGOCFMONITOR", "debug")
	$tooltips = RegRead("HKEY_CURRENT_USER\SOFTWARE\IGOCFMONITOR", "tooltips")

EndFunc
